/**
* Script: resources.js
* Written by: Radnen
* Updated: 12/20/2010
**/

/**
* Global Asset Manager:
*  - Automatically loads game assets.
*  - To access assets use their name in one of the
*    objects below. Say it automatically loads "face.png"
*    you can then use "Resources.images.face" to access it.
*		 The code *will* search sub-folders, but it doesn't
*		 sub-section the arrays inside. You can't use:
*		 "Resources.images.faces.face" to open the face.
**/
var Resources = ({
	// Default Paths Are Defined as Follows:
	imagePath        : "./images",
	soundPath        : "./sounds",
	musicPath        : "./music",
	fontPath         : "./fonts",
	scriptPath       : "./scripts",
	windowstylesPath : "./windowstyles",
	
	// public-access objects that hold loaded data:
	images       : {},
	fonts        : {},
	music        : {},
	sounds       : {},
	windowstyles : {},
	
	/**
	* loadRenderer();
	*  - overload this function to have a custom blited image.
	**/
	loadRenderer: function() {
		GetSystemFont().drawText(SW/2 - GetSystemFont().getStringWidth("Loading Content...")/2, SH/2, "Loading Content...");
	},
	
	/**
	* loadScripts([path]);
	*  - path: the script path, if none defaults to '/scripts'.
	**/
	loadScripts: function(path) {
		if (path === undefined) path = this.scriptPath;

		var files = GetFileList(path);
		for (var i = 0; i < files.length; ++i) RequireScript(files[i]);
	},
	
	/**
	* loadAll();
	*  - immediately loads all of the content into respective subfolders.
	**/
	loadAll: function() {
		this.loadRenderer();
		FlipScreen();
		this.load(this.images, this.imagePath, LoadImage);
		this.load(this.sounds, this.soundPath, LoadSound);
		this.load(this.music, this.musicPath, LoadSound);
		this.load(this.fonts, this.fontPath, LoadFont);
		this.load(this.windowstyles, this.windowstylesPath, LoadWindowStyle);
		
		// Rad-Lib Specifics:
		Cursor.image = this.images.cursor;
	},
	
	/**
	* Loads all contents from path into array.
	*  - array: array or object to hold tsuff in.
	*  - path: the filepath of the root folder to start loading from.
	*  - func: has to be any one of sphere's load functions.
	**/
	load: function(array, path, func) {
		var dirs = GetDirectoryList(path);
		for(var i = 0; i < dirs.length; ++i) {
			this.load(array, path+"/"+dirs[i], func);
		}
		
		var files = GetFileList(path), str, i = files.length;
		while(i--) {
			str = files[i];
			if (str.indexOf("Thumbs.db") >= 0) continue;
			array[str.substr(0, str.lastIndexOf("."))] = func("."+path+"/"+str);
		}
	},
});